package lrs;

/**
 * Represents the non-empty state of a LStruct.
 * @author Dung X. Nguyen and Stephen Wong  Copyright 2005 - All rights reserved.
 * @since 8/25/05
 */
class NENode<E> extends ANode<E> {
  private E _dat;
  private LRStruct<E> _tail;
  
  /**
   * Initializes this NENode to contain dat and a given tail list.
   * @param dat the data object to be stored in this NENode.
   * @param tail the LRStruct tail of this NENode.
   */
  NENode(E dat, LRStruct<E> tail) {
    _dat = dat;
    _tail = tail;
  }
  
  LRStruct<E> getRest(LRStruct<E> owner) {
    return _tail;
  }
  
  E getFirst(LRStruct<E> owner) {
    return _dat;
  }
  
  LRStruct<E> setRest(LRStruct<E> tail, LRStruct<E> owner) {
    _tail = tail;
    return owner;
  }
  
  LRStruct<E> setFirst(E first, LRStruct<E> owner) {
    _dat = first;
    return owner;
  }
  
  /**
   * Inserts a data object at the front of the LRStruct owner.
   * @param dat the object to be inserted at the front.
   * @param owner the LRS referencing this NENode.
   */
  LRStruct<E> insertFront(E dat, LRStruct<E> owner) {
    return owner.setHead(new NENode(dat, new LRStruct<E>(this)));
    /* Details:
     // LRStruct coOwner = new LRStruct (this);
     // NENode newNode = new NENode (dat, coOwner);
     // owner.setHead (newNode);
     // "old" style: owner._head = newNode - cannot be done here.
     */
  }
  
  E removeFront(LRStruct<E> owner) {
    owner.setHead(_tail.getHead()); // owner._head = _tail._head
    return _dat;
  }
  
  /**
   * Calls the visitor's non-empty case.
   */
  <R, P> R execute(LRStruct<E> owner, IAlgo<? super E, R, P> algo, P... input)  {
    return algo.nonEmptyCase(owner, input);
  }
}

